	function [CSDCVector] = TWO_V_2_CSDC_V(TwoCVector);
	
	% 	Converts a real two's-complement vector between -1 and 1 to a
	%	CSDC vector of wordlength n.
	% 	Works properly only when number can be described exactly with n bits, 
	%	i.e., no rounding has been implemented.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 			Oscar Gustafsson
	% 	Modified by: 	 	
	%	Copyright:			by authors - not released for commercial use
	% 	Version:			1	 
	% 	Known bugs:			
	% 	Report bugs to:		Wanhammar@gmail.com
	
	l = size(TwoCVector);
	l = l(1);
	for k = 1:l
		CSDCVector(k,:) = TWO_C_2_CSDC(TwoCVector(k,:));
	end
	
	
